/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class GroupAddrCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 7;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel device_Model;
    NavigationContext myContext;
    MessageBox messageToUser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Hashtable hashtable = jDMWizardInfo.getItems();
        hashtable.clear();
        hashtable.put("newPortMember", new OctetString("0000000000"));
        hashtable.put("newFilterMode", new Integer(1));
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        Hashtable hashtable = null;
        Integer n = null;
        String string = null;
        Serializable serializable = null;
        Integer n2 = null;
        OctetString octetString = null;
        String string2 = null;
        String string3 = "proceed";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string3);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string3, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (bl) {
            hashtable = jDMWizardInfo.getItems();
            genModel = jDMWizardInfo.getModel();
            try {
                octetString = (OctetString)hashtable.get("newMacAddress");
                n2 = (Integer)hashtable.get("newVlanIdNum");
                string2 = (String)hashtable.get("newGroupAddrName");
                serializable = (Serializable)hashtable.get("newPortMember");
                n = (Integer)hashtable.get("newFilterMode");
                if (string2.trim().length() == 0) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string3, "Missing group name- can't create row");
                    }
                    string = new String("GC_missingName");
                    bl = false;
                } else if (n2 <= 0) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string3, "invalid Vlan Num");
                    }
                    string = new String("WZ_invalidVlan");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "unexpected/missing user data- can't create row");
                }
                RAS.logException(19, 7, this, string3, exception);
                string = new String("WZ_missingInfo");
                bl = false;
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.MacAddr", octetString);
            modelInfo.add("Index.VlanIdNum", n2);
            try {
                modelInfo = genModel.getInfo("Panel", "default", modelInfo);
                if (modelInfo.get("Panel.GroupAddrOperState") instanceof Integer) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string3, "Group address already exists");
                    }
                    string = new String("GC_already exists");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "unexpected bypassable exception");
                }
                RAS.logException(19, 7, this, string3, exception);
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.MacAddr", octetString);
            modelInfo.add("Index.VlanIdNum", n2);
            modelInfo.add("Panel.GroupAddrName", (Serializable)((Object)string2));
            modelInfo.add("Panel.GroupAddrPortMember", serializable);
            modelInfo.add("Panel.GroupAddrAdminStatus", n);
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSnmpResponse(modelInfo);
                if (!bl) {
                    string = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                bl = false;
                string = new String("WZ_badSet");
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string3, "Exception setting Group Create data");
                }
                RAS.logException(19, 7, this, string3, exception);
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(GroupAddrCreate.getNLSString(string));
            this.messageToUser = new MessageBox(this.browser.getFrame(), GroupAddrCreate.getNLSString("GC_error"), GroupAddrCreate.getNLSString(string), true);
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string3);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        String string = "checkSnmpResponse";
        if (RAS.isEnabled(19, 7)) {
            RAS.enter(19, 7, this, string);
        }
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Error in snmp set. Variable is " + string2 + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        if (RAS.isEnabled(19, 7)) {
            RAS.exit(19, 7, this, string);
        }
        return bl;
    }
}

